<?php
require_once '../config.php';
require_once '../security.php';

$admin_active_page = 'transactions';

$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if($user_id <= 0) {
    header('Location: ../login.php');
    exit();
}

// Verify admin status
$admin_sql = "SELECT is_admin FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$admin_result = $mysql->query($admin_sql);
if($admin_result && $admin_result->num_rows > 0) {
    $user_data = $admin_result->fetch_assoc();
    if(intval($user_data['is_admin'] ?? 0) != 1) {
        header('Location: ../dashboard.php');
        exit();
    }
} else {
    header('Location: ../dashboard.php');
    exit();
}

if(empty($_REQUEST['id'])) {
    echo "Error. Please use the Transactions page.";
    exit();
}

$transaction_id = intval($_REQUEST['id']);

// Get transaction data
$sql = "SELECT t.transaction_id, t.account_id, t.category_id, t.amount, t.note, t.transaction_date
        FROM transactions t
        WHERE t.transaction_id = " . $transaction_id . "
        LIMIT 1";

$result = $mysql->query($sql);

if(!$result || $result->num_rows == 0) {
    echo "Transaction not found.";
    exit();
}

$transaction = $result->fetch_assoc();

// Get accounts for dropdown
$accounts_sql = "SELECT a.account_id, a.name, u.first_name, u.last_name, u.email 
                 FROM accounts a 
                 LEFT JOIN users u ON a.user_id = u.user_id 
                 ORDER BY u.email, a.name";
$accounts_result = $mysql->query($accounts_sql);
$accounts = [];
if($accounts_result) {
    while($row = $accounts_result->fetch_assoc()) {
        $accounts[] = $row;
    }
}

// Get categories for dropdown
$categories_sql = "SELECT category_id, label, type FROM categories ORDER BY type, label";
$categories_result = $mysql->query($categories_sql);
$categories = [];
if($categories_result) {
    while($row = $categories_result->fetch_assoc()) {
        $categories[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Transaction - Admin - Budget Buddy</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/admin.css">
</head>
<body class="admin-page">
    <?php include 'admin_nav.php'; ?>
    
    <main class="admin-main-content">
        <div class="admin-header">
            <h1>Edit Transaction</h1>
            <p class="admin-subtitle">Editing transaction #<?php echo $transaction_id; ?></p>
        </div>

        <div class="admin-form-container">
            <form method="GET" action="transaction_update.php" class="admin-form">
                <input type="hidden" name="id" value="<?php echo $transaction_id; ?>">

                <div class="form-group">
                    <label for="account_id">Account *</label>
                    <select id="account_id" name="account_id" required>
                        <?php foreach($accounts as $acc): ?>
                            <option value="<?php echo $acc['account_id']; ?>" 
                                    <?php echo ($acc['account_id'] == $transaction['account_id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($acc['name']); ?> 
                                (<?php echo htmlspecialchars(trim($acc['first_name'] . ' ' . $acc['last_name']) . ' - ' . $acc['email']); ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="category_id">Category</label>
                    <select id="category_id" name="category_id">
                        <option value="">None (Uncategorized)</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?php echo $cat['category_id']; ?>" 
                                    <?php echo ($cat['category_id'] == $transaction['category_id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($cat['label']); ?> (<?php echo htmlspecialchars($cat['type']); ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="amount">Amount *</label>
                    <input type="text" id="amount" name="amount" 
                           value="<?php echo htmlspecialchars($transaction['amount']); ?>" required>
                    <small>Positive for income, negative for expenses</small>
                </div>

                <div class="form-group">
                    <label for="note">Description/Note</label>
                    <textarea id="note" name="note" rows="3"><?php echo htmlspecialchars($transaction['note'] ?? ''); ?></textarea>
                </div>

                <div class="form-group">
                    <label for="transaction_date">Transaction Date *</label>
                    <input type="date" id="transaction_date" name="transaction_date" 
                           value="<?php echo date('Y-m-d', strtotime($transaction['transaction_date'])); ?>" required>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-submit">Update Transaction</button>
                    <a href="transactions.php" class="btn-cancel">Cancel</a>
                </div>
            </form>
        </div>
    </main>

</body>
</html>
<?php
$mysql->close();
?>

