<?php
require_once '../config.php';
require_once '../security.php';

$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if($user_id <= 0) {
    header('Location: ../login.php');
    exit();
}

// Verify admin status
$admin_sql = "SELECT is_admin FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$admin_result = $mysql->query($admin_sql);
if($admin_result && $admin_result->num_rows > 0) {
    $user_data = $admin_result->fetch_assoc();
    if(intval($user_data['is_admin'] ?? 0) != 1) {
        header('Location: ../dashboard.php');
        exit();
    }
} else {
    header('Location: ../dashboard.php');
    exit();
}

if(empty($_REQUEST['id'])) {
    echo "You reached this page in error.";
    exit();
}

$edit_user_id = intval($_REQUEST['id']);
$first_name = isset($_REQUEST['first_name']) ? trim($_REQUEST['first_name']) : '';
$last_name = isset($_REQUEST['last_name']) ? trim($_REQUEST['last_name']) : '';
$email = isset($_REQUEST['email']) ? trim($_REQUEST['email']) : '';
$is_admin = isset($_REQUEST['is_admin']) ? intval($_REQUEST['is_admin']) : 0;

// Validate required fields
if(empty($first_name) || empty($last_name) || empty($email)) {
    header('Location: user_edit.php?id=' . $edit_user_id . '&error=1');
    exit();
}

// Check if email is already taken by another user
$check_email_sql = "SELECT user_id FROM users WHERE email = '" . $mysql->real_escape_string($email) . "' AND user_id != " . $edit_user_id . " LIMIT 1";
$check_email_result = $mysql->query($check_email_sql);

if($check_email_result && $check_email_result->num_rows > 0) {
    header('Location: user_edit.php?id=' . $edit_user_id . '&error=email');
    exit();
}

// Prevent removing admin status from yourself
if($edit_user_id == $user_id && $is_admin == 0) {
    header('Location: user_edit.php?id=' . $edit_user_id . '&error=self');
    exit();
}

// Build update SQL
$sql = "UPDATE users SET 
        first_name = '" . $mysql->real_escape_string($first_name) . "', 
        last_name = '" . $mysql->real_escape_string($last_name) . "', 
        email = '" . $mysql->real_escape_string($email) . "', 
        is_admin = " . $is_admin . "
        WHERE user_id = " . $edit_user_id;

$result = $mysql->query($sql);

if(!$result) {
    echo "<hr>Your SQL:<br>" . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}

// Redirect back to users list
header('Location: users.php?updated=1');
exit();
?>

