<?php
require_once '../config.php';
require_once '../security.php';

$admin_active_page = 'users';

// Check if user is admin
$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if($user_id <= 0) {
    header('Location: ../login.php');
    exit();
}

// Verify admin status
$admin_sql = "SELECT is_admin FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$admin_result = $mysql->query($admin_sql);
if($admin_result && $admin_result->num_rows > 0) {
    $user_data = $admin_result->fetch_assoc();
    if(intval($user_data['is_admin'] ?? 0) != 1) {
        header('Location: ../dashboard.php');
        exit();
    }
} else {
    header('Location: ../dashboard.php');
    exit();
}

$message = '';
$message_type = '';

// Handle delete request
if(isset($_GET['delete']) && !empty($_GET['delete'])) {
    $delete_user_id = intval($_GET['delete']);
    
    // Prevent deleting yourself
    if($delete_user_id == $user_id) {
        $message = 'You cannot delete your own account!';
        $message_type = 'error';
    } elseif($delete_user_id > 0) {
        $delete_sql = "DELETE FROM users WHERE user_id = " . $delete_user_id;
        if($mysql->query($delete_sql)) {
            $message = 'User deleted successfully!';
            $message_type = 'success';
            header('Location: users.php?deleted=1');
            exit();
        } else {
            $message = 'Error deleting user: ' . $mysql->error;
            $message_type = 'error';
        }
    }
}

// Check for success message from redirect
if(isset($_GET['deleted']) && $_GET['deleted'] == 1) {
    $message = 'User deleted successfully!';
    $message_type = 'success';
}

if(isset($_GET['updated']) && $_GET['updated'] == 1) {
    $message = 'User updated successfully!';
    $message_type = 'success';
}

// Search and filter
$search = isset($_REQUEST['search']) ? trim($_REQUEST['search']) : '';
$admin_filter = isset($_REQUEST['admin']) ? trim($_REQUEST['admin']) : 'all';

// Build query
$sql = "SELECT user_id, first_name, last_name, email, is_admin, created_at
        FROM users
        WHERE 1=1";

if(!empty($search)) {
    $sql .= " AND (first_name LIKE '%" . $mysql->real_escape_string($search) . "%' 
                   OR last_name LIKE '%" . $mysql->real_escape_string($search) . "%'
                   OR email LIKE '%" . $mysql->real_escape_string($search) . "%')";
}

if($admin_filter != "all" && !empty($admin_filter)) {
    if($admin_filter == "yes") {
        $sql .= " AND is_admin = 1";
    } else {
        $sql .= " AND is_admin = 0";
    }
}

$sql .= " ORDER BY created_at DESC, user_id DESC";

// Get total count for pagination
$count_results = $mysql->query($sql);
if(!$count_results) {
    echo "<hr>Your SQL:<br> " . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}
$count = $count_results->num_rows;

// Pagination setup
$records_per_page = 20;
$start = isset($_REQUEST['start']) ? intval($_REQUEST['start']) : 1;
if($start < 1) $start = 1;

$end = $start + $records_per_page - 1;
if($count < $end) {
    $end = $count;
}

// Add LIMIT to main query
$sql .= " LIMIT " . ($start - 1) . ", " . $records_per_page;

$results = $mysql->query($sql);

if(!$results) {
    echo "<hr>Your SQL:<br> " . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Users - Budget Buddy</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/admin.css">
</head>
<body class="admin-page">
    <?php include 'admin_nav.php'; ?>
    
    <main class="admin-main-content">
        <div class="admin-header">
            <h1>Manage Users</h1>
            <p class="admin-subtitle">View, edit, and manage all user accounts</p>
        </div>

        <?php if($message): ?>
            <div class="admin-message <?php echo $message_type; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <div class="admin-filter-bar">
            <form method="GET" action="users.php" style="display: flex; gap: 10px; align-items: center; flex-wrap: wrap;">
                <div class="search-box">
                    <input type="text" name="search" placeholder="Search users by name or email..." value="<?php echo htmlspecialchars($search); ?>">
                </div>
                <select name="admin" class="filter-dropdown">
                    <option value="all" <?php echo $admin_filter == 'all' ? 'selected' : ''; ?>>All Users</option>
                    <option value="yes" <?php echo $admin_filter == 'yes' ? 'selected' : ''; ?>>Admins Only</option>
                    <option value="no" <?php echo $admin_filter == 'no' ? 'selected' : ''; ?>>Regular Users Only</option>
                </select>
                <button type="submit" class="btn-filter">Filter</button>
                <a href="users.php" class="btn-clear">Clear</a>
            </form>
        </div>

        <div class="admin-actions">
            <span class="result-count">
                <?php 
                if($count > 0) {
                    echo "Showing " . $start . "-" . $end . " of " . $count . " user" . ($count != 1 ? 's' : '');
                } else {
                    echo "No users found";
                }
                ?>
            </span>
        </div>

        <div class="admin-table-container">
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if($results->num_rows > 0) {
                        while($row = $results->fetch_assoc()) {
                            $display_user_id = intval($row['user_id']);
                            $first_name = htmlspecialchars($row['first_name'] ?? '');
                            $last_name = htmlspecialchars($row['last_name'] ?? '');
                            $full_name = trim($first_name . ' ' . $last_name);
                            $email = htmlspecialchars($row['email'] ?? '');
                            $is_admin = intval($row['is_admin'] ?? 0);
                            $created_at = $row['created_at'] ?? '';
                            $created_date = !empty($created_at) ? date('Y-m-d', strtotime($created_at)) : 'N/A';
                            
                            $role_badge = $is_admin == 1 ? '<span style="background-color: #4CAF50; color: white; padding: 4px 8px; border-radius: 4px; font-size: 0.75rem; font-weight: 500;">Admin</span>' : '<span style="background-color: #f5f5f5; color: #666; padding: 4px 8px; border-radius: 4px; font-size: 0.75rem; font-weight: 500;">User</span>';
                            ?>
                            <tr>
                                <td><?php echo $display_user_id; ?></td>
                                <td><?php echo $full_name; ?></td>
                                <td><?php echo $email; ?></td>
                                <td><?php echo $role_badge; ?></td>
                                <td><?php echo $created_date; ?></td>
                                <td>
                                    <a href="user_edit.php?id=<?php echo $display_user_id; ?>" class="btn-edit">Edit</a>
                                    <?php if($display_user_id != $user_id): ?>
                                        <a href="users.php?delete=<?php echo $display_user_id; ?>" 
                                           class="btn-delete" 
                                           onclick="return confirm('Are you sure you want to delete this user? This action cannot be undone.');">Delete</a>
                                    <?php else: ?>
                                        <span style="color: #999; font-size: 0.875rem;">(Current User)</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="6" style="text-align: center; padding: 2rem; color: #666;">
                                No users found.
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <?php if($count > $records_per_page): ?>
        <div class="pagination-container">
            <?php if($start > 1): ?>
            <form method="GET" action="users.php" style="display: inline-block;">
                <input type="hidden" name="start" value="<?php echo max(1, $start - $records_per_page); ?>">
                <input type="hidden" name="search" value="<?php echo htmlspecialchars($search); ?>">
                <input type="hidden" name="admin" value="<?php echo htmlspecialchars($admin_filter); ?>">
                <button type="submit" class="btn-pagination">← Previous</button>
            </form>
            <?php endif; ?>
            
            <span class="pagination-info">
                Page <?php echo ceil($start / $records_per_page); ?> of <?php echo ceil($count / $records_per_page); ?>
            </span>
            
            <?php if($end < $count): ?>
            <form method="GET" action="users.php" style="display: inline-block;">
                <input type="hidden" name="start" value="<?php echo $start + $records_per_page; ?>">
                <input type="hidden" name="search" value="<?php echo htmlspecialchars($search); ?>">
                <input type="hidden" name="admin" value="<?php echo htmlspecialchars($admin_filter); ?>">
                <button type="submit" class="btn-pagination">Next →</button>
            </form>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </main>

</body>
</html>
<?php
$mysql->close();
?>

