<?php
session_start();
$current_page = 'features';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Features - Budget Buddy</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="public-page">
    <?php include 'includes/navigation.php'; ?>
    
    <main class="public-content">
        <section class="page-header-section">
            <h1>Features</h1>
            <p class="page-subtitle">Everything you need to manage your budget effectively</p>
        </section>

        <section class="content-section">
            <div class="content-container">
                <div class="feature-detail">
                    <div class="feature-icon-large">📊</div>
                    <h2>Comprehensive Transaction Tracking</h2>
                    <p>Record every income and expense with detailed categories. Our flexible categorization system lets you organize transactions exactly how you want. Add notes, dates, and amounts to keep complete records of your financial activity.</p>
                </div>

                <div class="feature-detail">
                    <div class="feature-icon-large">💼</div>
                    <h2>Multiple Account Management</h2>
                    <p>Manage all your financial accounts in one place. Whether you have checking accounts, savings accounts, credit cards, or investment accounts, Budget Buddy helps you keep track of everything. See balances and transactions across all accounts at a glance.</p>
                </div>

                <div class="feature-detail">
                    <div class="feature-icon-large">📈</div>
                    <h2>Visual Analytics & Reports</h2>
                    <p>Understand your finances with beautiful charts and graphs. View income vs. expenses over time, see spending breakdowns by category, and identify trends in your financial behavior. Our visualizations make it easy to spot patterns and make informed decisions.</p>
                </div>

                <div class="feature-detail">
                    <div class="feature-icon-large">🔍</div>
                    <h2>Powerful Search & Filtering</h2>
                    <p>Find any transaction quickly with our advanced search and filtering tools. Search by description, filter by category or type, and sort by date or amount. Never lose track of a transaction again.</p>
                </div>

                <div class="feature-detail">
                    <div class="feature-icon-large">📱</div>
                    <h2>Easy-to-Use Interface</h2>
                    <p>Our clean, intuitive interface makes budget management simple. Whether you're adding a new transaction, viewing your dashboard, or exploring your financial data, everything is designed to be straightforward and user-friendly.</p>
                </div>

                <div class="feature-detail">
                    <div class="feature-icon-large">🔒</div>
                    <h2>Secure & Private</h2>
                    <p>Your financial data is encrypted and stored securely. We use industry-standard security practices to protect your information. Your privacy is our priority, and we never share your data with third parties.</p>
                </div>

                <div class="cta-box">
                    <h2>Ready to Experience These Features?</h2>
                    <p>Start using Budget Buddy today and see how easy budget management can be.</p>
                    <a href="signup.php" class="btn-light">Get Started Free</a>
                </div>
            </div>
        </section>
    </main>

    <?php include 'includes/footer.php'; ?>

    <style>
        .page-header-section {
            background: white;
            color: #1e3a5f;
            padding: 60px 2rem;
            text-align: center;
        }
        .content-section {
            padding: 60px 2rem;
        }
        .content-container {
            max-width: 900px;
            margin: 0 auto;
        }
        .feature-detail {
            margin-bottom: 3rem;
            padding: 2rem;
            background-color: #ffffff;
            border-radius: 8px;
            border: 1px solid #ddd;
        }
        .feature-icon-large {
            font-size: 4rem;
            text-align: center;
            margin-bottom: 1rem;
        }
        .feature-detail h2 {
            color: #1e3a5f;
            margin-bottom: 1rem;
        }
        .cta-box {
            background: linear-gradient(135deg, #1e3a5f 0%, #102a43 100%);
            color: white;
            padding: 3rem;
            border-radius: 8px;
            text-align: center;
            margin-top: 3rem;
        }
        .cta-box h2 {
            color: white;
            margin-bottom: 1rem;
        }
    </style>
</body>
</html>

