<?php
// Main site navigation include
$current_page = isset($current_page) ? $current_page : '';
?>
<nav class="main-site-nav">
    <div class="nav-brand">
        <a href="index.php">
            <img src="logo2.png" alt="Budget Buddy" width="50" height="50">
            <span>Budget Buddy</span>
        </a>
    </div>
    <ul class="nav-menu">
        <li><a href="index.php" class="<?php echo ($current_page == 'home') ? 'active' : ''; ?>">Home</a></li>
        <li><a href="features.php" class="<?php echo ($current_page == 'features') ? 'active' : ''; ?>">Features</a></li>
        <?php if(!empty($_SESSION['loggedin']) && $_SESSION['loggedin'] === 'yes'): ?>
            <li><a href="dashboard.php">Dashboard</a></li>
            <?php if(isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1): ?>
                <li><a href="admin/index.php">Admin</a></li>
            <?php endif; ?>
            <li><a href="logout.php">Logout</a></li>
        <?php else: ?>
            <li><a href="login.php" class="nav-login-btn">Login</a></li>
            <li><a href="signup.php" class="nav-signup-btn">Sign Up</a></li>
        <?php endif; ?>
    </ul>
</nav>

<style>
.main-site-nav {
    background-color: #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    padding: 1rem 2rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: sticky;
    top: 0;
    z-index: 1000;
}

.nav-brand {
    display: flex;
    align-items: center;
    gap: 10px;
    font-size: 1.5rem;
    font-weight: bold;
    color: #1e3a5f;
}

.nav-brand a {
    display: flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    color: inherit;
}

.nav-menu {
    display: flex;
    list-style: none;
    gap: 2rem;
    align-items: center;
    margin: 0;
    padding: 0;
}

.nav-menu li a {
    text-decoration: none;
    color: #333;
    font-weight: 500;
    transition: color 0.3s;
}

.nav-menu li a:hover,
.nav-menu li a.active {
    color: #1e3a5f;
}

.nav-login-btn {
    color: #1e3a5f !important;
}

.nav-signup-btn {
    background-color: #1e3a5f;
    color: white !important;
    padding: 8px 16px;
    border-radius: 6px;
    transition: background-color 0.3s;
}

.nav-signup-btn:hover {
    background-color: #152a47;
}
</style>

