<?php
require_once 'config.php';
include 'security.php';

// Get the logged-in user's ID
$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;

if($user_id <= 0) {
    header('Location: login.php');
    exit();
}

$message = '';
$message_type = '';

// Get current user information
$user_sql = "SELECT first_name, last_name, email FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$user_result = $mysql->query($user_sql);
$current_user = null;
if($user_result && $user_result->num_rows > 0) {
    $current_user = $user_result->fetch_assoc();
}

// Handle form submission
if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $first_name = isset($_POST['first_name']) ? trim($_POST['first_name']) : '';
    $last_name = isset($_POST['last_name']) ? trim($_POST['last_name']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $current_password = isset($_POST['current_password']) ? $_POST['current_password'] : '';
    $new_password = isset($_POST['new_password']) ? $_POST['new_password'] : '';
    $confirm_password = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';

    // Validate required fields
    if(empty($first_name) || empty($last_name) || empty($email)) {
        $message = 'Please fill in all required fields.';
        $message_type = 'error';
    } else {
        // Check if email is already taken by another user
        $check_email_sql = "SELECT user_id FROM users WHERE email = '" . $mysql->real_escape_string($email) . "' AND user_id != " . $user_id . " LIMIT 1";
        $check_email_result = $mysql->query($check_email_sql);

        if($check_email_result && $check_email_result->num_rows > 0) {
            $message = 'Email is already in use by another account.';
            $message_type = 'error';
        } else {
            // Update user information
            $update_sql = "UPDATE users SET first_name = '" . $mysql->real_escape_string($first_name) . "', 
                          last_name = '" . $mysql->real_escape_string($last_name) . "', 
                          email = '" . $mysql->real_escape_string($email) . "'";

            // If password change is requested
            if(!empty($new_password)) {
                if(empty($current_password)) {
                    $message = 'Please enter your current password to change it.';
                    $message_type = 'error';
                } else if($new_password != $confirm_password) {
                    $message = 'New passwords do not match.';
                    $message_type = 'error';
                } else {
                    // Verify current password
                    $verify_sql = "SELECT password_hash FROM users WHERE user_id = " . $user_id . " LIMIT 1";
                    $verify_result = $mysql->query($verify_sql);
                    if($verify_result && $verify_result->num_rows > 0) {
                        $user_data = $verify_result->fetch_assoc();
                        if(password_verify($current_password, $user_data['password_hash'])) {
                            // Hash new password
                            $password_hash = password_hash($new_password, PASSWORD_DEFAULT);
                            $update_sql .= ", password_hash = '" . $mysql->real_escape_string($password_hash) . "'";
                        } else {
                            $message = 'Current password is incorrect.';
                            $message_type = 'error';
                        }
                    }
                }
            }

            // Execute update if no errors
            if($message_type != 'error') {
                $update_sql .= " WHERE user_id = " . $user_id;
                if($mysql->query($update_sql)) {
                    $message = 'Settings updated successfully!';
                    $message_type = 'success';
                    // Update session user name
                    $_SESSION['user_name'] = trim($first_name . ' ' . $last_name);
                    // Refresh user data
                    $user_result = $mysql->query($user_sql);
                    if($user_result && $user_result->num_rows > 0) {
                        $current_user = $user_result->fetch_assoc();
                    }
                } else {
                    $message = 'Error updating settings: ' . $mysql->error;
                    $message_type = 'error';
                }
            }
        }
    }
}

// Check for success message
if(isset($_GET['success']) && $_GET['success'] == 1) {
    $message = 'Settings updated successfully!';
    $message_type = 'success';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Budget Buddy</title>
    <link rel="stylesheet" href="css/style.css?v=<?php echo time(); ?>">
</head>
<body class="settings-page">
<?php
$active_page = 'settings';
include 'sidebar.php';
?>

<main class="main-content">
    <!-- Page Header -->
    <div class="page-header">
        <h1 class="page-title">Settings</h1>
        <p class="page-subtitle">Manage your account settings and preferences</p>
    </div>

    <div class="content-layout">
        <!-- Left Column: Settings Form -->
        <div class="form-section">
            <?php if($message): ?>
                <div class="message <?php echo $message_type; ?>" style="padding: 12px; margin-bottom: 20px; border-radius: 6px; <?php echo $message_type == 'success' ? 'background-color: #e8f5e9; color: #2e7d32; border: 1px solid #4caf50;' : 'background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;'; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <!-- Profile Information Section -->
            <div class="info-banner" style="background-color: #f5f5f5; border: 1px solid #ddd; padding: 16px; margin-bottom: 24px; border-radius: 6px;">
                <div style="font-size: 16px; font-weight: 600; color: #333; margin-bottom: 4px;">Profile Information</div>
                <div style="font-size: 13px; color: #666;">Update your personal information</div>
            </div>

            <form method="POST" action="settings.php" class="income-form">
                <div class="form-field">
                    <label for="first_name">First Name</label>
                    <input type="text" id="first_name" name="first_name" placeholder="John" value="<?php echo htmlspecialchars($current_user['first_name'] ?? ''); ?>" required>
                </div>

                <div class="form-field">
                    <label for="last_name">Last Name</label>
                    <input type="text" id="last_name" name="last_name" placeholder="Doe" value="<?php echo htmlspecialchars($current_user['last_name'] ?? ''); ?>" required>
                </div>

                <div class="form-field">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" placeholder="you@example.com" value="<?php echo htmlspecialchars($current_user['email'] ?? ''); ?>" required>
                </div>

                <!-- Password Change Section -->
                <div class="info-banner" style="background-color: #f5f5f5; border: 1px solid #ddd; padding: 16px; margin-top: 32px; margin-bottom: 24px; border-radius: 6px;">
                    <div style="font-size: 16px; font-weight: 600; color: #333; margin-bottom: 4px;">Change Password</div>
                    <div style="font-size: 13px; color: #666;">Leave blank to keep current password</div>
                </div>

                <div class="form-field">
                    <label for="current_password">Current Password</label>
                    <input type="password" id="current_password" name="current_password" placeholder="Enter current password">
                </div>

                <div class="form-field">
                    <label for="new_password">New Password</label>
                    <input type="password" id="new_password" name="new_password" placeholder="Enter new password">
                </div>

                <div class="form-field">
                    <label for="confirm_password">Confirm New Password</label>
                    <input type="password" id="confirm_password" name="confirm_password" placeholder="Confirm new password">
                </div>

                <button type="submit" class="submit-button" style="background-color: #333; border-color: #333;">
                    <span>✓</span>
                    <span>Save Changes</span>
                </button>
            </form>
        </div>

        <!-- Right Column: Account Summary -->
        <div class="sidebar-section">
            <!-- Account Info Card -->
            <div class="summary-card">
                <div class="card-header-section">
                    <div class="card-title-section">Account Information</div>
                    <div class="card-subtitle-section">Your profile details</div>
                </div>
                <div class="summary-stats">
                    <div class="summary-stat" style="border-bottom: 1px solid #eee; padding-bottom: 12px; margin-bottom: 12px;">
                        <span class="summary-stat-label">Full Name</span>
                        <span class="summary-stat-value" style="font-size: 16px; color: #333; font-weight: 600;">
                                <?php echo htmlspecialchars(($current_user['first_name'] ?? '') . ' ' . ($current_user['last_name'] ?? '')); ?>
                            </span>
                    </div>

                    <div class="summary-stat" style="border-bottom: 1px solid #eee; padding-bottom: 12px; margin-bottom: 12px;">
                        <span class="summary-stat-label">Email</span>
                        <span class="summary-stat-value" style="font-size: 14px; color: #666;">
                                <?php echo htmlspecialchars($current_user['email'] ?? ''); ?>
                            </span>
                    </div>

                    <div class="summary-stat" style="border-bottom: none;">
                        <span class="summary-stat-label">User ID</span>
                        <span class="summary-stat-value" style="font-size: 14px; color: #666;">
                                <?php echo $user_id; ?>
                            </span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions Card -->
            <!--
            <div class="recent-income-card" style="margin-top: 20px;">
                <div class="card-header-section">
                    <div class="card-title-section">Quick Actions</div>
                    <div class="card-subtitle-section">Account management</div>
                </div>

                <div class="income-list">
                    <a href="dashboard.php" style="text-decoration: none; color: inherit;">
                        <div class="income-item" style="cursor: pointer; padding: 12px;">
                            <div class="income-item-info">
                                <div class="income-item-title">View Dashboard</div>
                                <div class="income-item-meta">Go to your budget overview</div>
                            </div>
                            <div class="income-item-amount" style="font-size: 18px;">→</div>
                        </div>
                    </a>

                    <a href="transactions.php" style="text-decoration: none; color: inherit;">
                        <div class="income-item" style="cursor: pointer; padding: 12px;">
                            <div class="income-item-info">
                                <div class="income-item-title">View Transactions</div>
                                <div class="income-item-meta">See all your transactions</div>
                            </div>
                            <div class="income-item-amount" style="font-size: 18px;">→</div>
                        </div>
                    </a>
                </div>
            </div>
            -->
        </div>
    </div>
</main>
</body>
</html>
<?php
$mysql->close();
?>
